/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.DataRanged;

public class SubGuiNpcProjectiles
extends SubGuiInterface
implements ITextfieldListener {
    private static final String[] potionNames = new String[]{"gui.none", "tile.fire.name", "effect.poison", "effect.hunger", "effect.weakness", "effect.moveSlowdown", "effect.confusion", "effect.blindness", "effect.wither"};
    private static final String[] trailNames = new String[]{"gui.none", "Smoke", "Portal", "Redstone", "Lightning", "LargeSmoke", "Magic", "Enchant"};
    private final DataRanged stats;

    public SubGuiNpcProjectiles(DataRanged st) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.stats = st;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.stats.setHasGravity(button.getValue() == 1);
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.stats.setAccelerate(button.getValue() == 1);
                break;
            }
            case 3: {
                this.stats.setExplodeSize(button.getValue());
                break;
            }
            case 4: {
                this.stats.setEffect(button.getValue(), this.stats.getEffectStrength(), this.stats.getEffectTime());
                this.func_73866_w_();
                break;
            }
            case 5: {
                this.stats.setParticle(button.getValue());
                break;
            }
            case 6: {
                this.stats.setGlows(button.getValue() == 1);
                break;
            }
            case 7: {
                this.stats.setRender3D(button.getValue() == 1);
                this.func_73866_w_();
                break;
            }
            case 8: {
                this.stats.setSpins(button.getValue() == 1);
                break;
            }
            case 9: {
                this.stats.setSticks(button.getValue() == 1);
                break;
            }
            case 10: {
                this.stats.setEffect(this.stats.getEffectType(), button.getValue(), this.stats.getEffectTime());
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiNpcLabel(1, "enchantment.arrowDamage", this.guiLeft + 5, this.guiTop + 15));
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 45, this.guiTop + 10, 50, 18, this.stats.getStrength() + "");
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, 5L);
        textField.setHoverText("stats.hover.attack.strength", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(2, "enchantment.arrowKnockback", this.guiLeft + 110, this.guiTop + 15));
        textField = new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 150, this.guiTop + 10, 50, 18, this.stats.getKnockback() + "");
        textField.setMinMaxDefault(0L, 3L, 0L);
        textField.setHoverText("stats.hover.attack.knockback", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(3, "stats.size", this.guiLeft + 5, this.guiTop + 45));
        textField = new GuiNpcTextField(3, this, this.field_146289_q, this.guiLeft + 45, this.guiTop + 40, 50, 18, this.stats.getSize() + "");
        textField.setMinMaxDefault(2L, 20L, 10L);
        textField.setHoverText("stats.hover.bullet.size", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(4, "stats.speed", this.guiLeft + 5, this.guiTop + 75));
        textField = new GuiNpcTextField(4, this, this.field_146289_q, this.guiLeft + 45, this.guiTop + 70, 50, 18, this.stats.getSpeed() + "");
        textField.setMinMaxDefault(1L, 50L, 10L);
        textField.setHoverText("stats.hover.bullet.speed", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(5, "stats.hasgravity", this.guiLeft + 5, this.guiTop + 105));
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + 60, this.guiTop + 100, 60, 20, new String[]{"gui.no", "gui.yes"}, this.stats.getHasGravity() ? 1 : 0);
        button.setHoverText("stats.hover.gravity", new Object[0]);
        this.addButton(button);
        if (!this.stats.getHasGravity()) {
            button = new GuiNpcButton(1, this.guiLeft + 140, this.guiTop + 100, 60, 20, new String[]{"gui.constant", "gui.accelerate"}, this.stats.getAccelerate() ? 1 : 0);
            button.setHoverText("stats.hover.accelerating", new Object[0]);
            this.addButton(button);
        }
        this.addLabel(new GuiNpcLabel(6, "stats.explosive", this.guiLeft + 5, this.guiTop + 135));
        button = new GuiNpcButton(3, this.guiLeft + 60, this.guiTop + 130, 60, 20, new String[]{"gui.none", "gui.small", "gui.medium", "gui.large"}, this.stats.getExplodeSize() % 4);
        button.setHoverText("stats.hover.explosion", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(7, "stats.rangedeffect", this.guiLeft + 5, this.guiTop + 165));
        button = new GuiNpcButton(4, this.guiLeft + 60, this.guiTop + 160, 60, 20, potionNames, this.stats.getEffectType());
        button.setHoverText("stats.hover.attack.effects", new Object[0]);
        this.addButton(button);
        if (this.stats.getEffectType() != 0) {
            textField = new GuiNpcTextField(5, this, this.field_146289_q, this.guiLeft + 140, this.guiTop + 160, 60, 18, this.stats.getEffectTime() + "");
            textField.setMinMaxDefault(1L, 99999L, 5L);
            textField.setHoverText("stats.hover.effect.time", new Object[0]);
            this.addTextField(textField);
            if (this.stats.getEffectType() != 1) {
                button = new GuiNpcButton(10, this.guiLeft + 210, this.guiTop + 160, 40, 20, new String[]{"stats.regular", "stats.amplified"}, this.stats.getEffectStrength() % 2);
                button.setHoverText("stats.hover.effect.power", new Object[0]);
                this.addButton(button);
            }
        }
        this.addLabel(new GuiNpcLabel(8, "stats.trail", this.guiLeft + 5, this.guiTop + 195));
        button = new GuiNpcButton(5, this.guiLeft + 60, this.guiTop + 190, 60, 20, trailNames, this.stats.getParticle());
        button.setHoverText("stats.hover.particle", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(7, this.guiLeft + 220, this.guiTop + 10, 30, 20, new String[]{"2D", "3D"}, this.stats.getRender3D() ? 1 : 0);
        button.setHoverText("stats.hover.bullet.3d", new Object[0]);
        this.addButton(button);
        if (this.stats.getRender3D()) {
            this.addLabel(new GuiNpcLabel(10, "stats.spin", this.guiLeft + 160, this.guiTop + 45));
            button = new GuiNpcButton(8, this.guiLeft + 220, this.guiTop + 40, 30, 20, new String[]{"gui.no", "gui.yes"}, this.stats.getSpins() ? 1 : 0);
            button.setHoverText("stats.hover.bullet.rotate", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(11, "stats.stick", this.guiLeft + 160, this.guiTop + 75));
            button = new GuiNpcButton(9, this.guiLeft + 220, this.guiTop + 70, 30, 20, new String[]{"gui.no", "gui.yes"}, this.stats.getSticks() ? 1 : 0);
            button.setHoverText("stats.hover.bullet.cling", new Object[0]);
            this.addButton(button);
        }
        button = new GuiNpcButton(6, this.guiLeft + 140, this.guiTop + 190, 60, 20, new String[]{"stats.noglow", "stats.glows"}, this.stats.getGlows() ? 1 : 0);
        button.setHoverText("stats.hover.in.fire", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, this.guiLeft + 210, this.guiTop + 190, 40, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        switch (textfield.getID()) {
            case 1: {
                this.stats.setStrength(textfield.getInteger());
                break;
            }
            case 2: {
                this.stats.setKnockback(textfield.getInteger());
                break;
            }
            case 3: {
                this.stats.setSize(textfield.getInteger());
                break;
            }
            case 4: {
                this.stats.setSpeed(textfield.getInteger());
                break;
            }
            case 5: {
                this.stats.setEffect(this.stats.getEffectType(), this.stats.getEffectStrength(), textfield.getInteger());
            }
        }
    }
}

